#include "SSH.h"

// ssh_keyboard_callback: Authenticates a session, using keyboard-interactive authentication.
// This callback is a part of libbssh2, and calls U++ WhenKeyboard callback.

namespace Upp {

void ssh_keyboard_callback(const char *name, int name_len, const char *instruction, int instruction_len, 
     int num_prompts, const LIBSSH2_USERAUTH_KBDINT_PROMPT *prompts, LIBSSH2_USERAUTH_KBDINT_RESPONSE *responses, 
     void **abstract)
{
	Ssh* session = static_cast<Ssh*>(*abstract);
	for(auto i = 0; i < num_prompts; i++) {
		auto response = session->WhenKeyboard(
			*session,
			String(name, name_len),
			String(instruction, instruction_len),
			String(prompts[i].text, prompts[i].length)
		);
#ifdef flagUSEMALLOC
		auto *r = strdup(~response);
#else
		auto *r = (char*) ssh_malloc(response.GetLength(), abstract);
		memcpy(r, response.Begin(), response.GetLength());
#endif
		if(r) {
			responses[i].text   = r;
			responses[i].length = response.GetLength();
		}
	}
}
}